/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.FrameBlock;
import net.geforcemods.securitycraft.entity.camera.CameraFeed;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class FrameBlockEntityRenderer
implements BlockEntityRenderer<FrameBlockEntity> {
    private static final ResourceLocation CAMERA_NOT_FOUND = SecurityCraft.resLoc("textures/entity/frame/camera_not_found.png");
    private static final ResourceLocation INACTIVE = SecurityCraft.resLoc("textures/entity/frame/inactive.png");
    private static final ResourceLocation NO_REDSTONE_SIGNAL = SecurityCraft.resLoc("textures/entity/frame/no_redstone_signal.png");
    private static final Material NOISE_BACKGROUND = new Material(InventoryMenu.BLOCK_ATLAS, SecurityCraft.resLoc("entity/frame/noise_background"));
    private static final ResourceLocation SELECT_CAMERA = SecurityCraft.resLoc("textures/entity/frame/select_camera.png");
    private static final RenderType CAMERA_IN_FRAME_RENDER_TYPE = RenderType.create((String)"frame_shader", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(ClientHandler::getFrameFeedShader)).createCompositeState(false));

    public FrameBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(FrameBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (be.isDisabled() || !be.isOwnedBy((Entity)player) && !be.isAllowed((Entity)player) || be.getCameraPositions().isEmpty()) {
            return;
        }
        Level level = be.getLevel();
        BlockState state = be.getBlockState();
        GlobalPos cameraPos = be.getCurrentCamera();
        Direction direction = (Direction)state.getValue((Property)FrameBlock.FACING);
        Vec3i normal = direction.getNormal();
        float margin = 0.0625f;
        float xStart = 0.0f;
        float xEnd = 1.0f;
        float zStart = 0.0f;
        float zEnd = 1.0f;
        switch (direction) {
            case NORTH: {
                xStart = 0.0625f;
                xEnd = 0.9375f;
                zEnd = 0.05f;
                zStart = 0.05f;
                break;
            }
            case SOUTH: {
                xStart = 0.9375f;
                xEnd = 0.0625f;
                zEnd = 0.95f;
                zStart = 0.95f;
                break;
            }
            case WEST: {
                zStart = 0.9375f;
                zEnd = 0.0625f;
                xEnd = 0.05f;
                xStart = 0.05f;
                break;
            }
            case EAST: {
                zStart = 0.0625f;
                zEnd = 0.9375f;
                xEnd = 0.95f;
                xStart = 0.95f;
                break;
            }
        }
        if (cameraPos == null) {
            this.renderSolidTexture(pose, buffer, SELECT_CAMERA, xStart, xEnd, zStart, zEnd, packedLight, normal, 0.0625f);
        } else if (be.redstoneSignalDisabled()) {
            this.renderNoise(pose, buffer, xStart, xEnd, zStart, zEnd, packedLight, normal, 0.0625f);
            this.renderCutoutTexture(pose, buffer, NO_REDSTONE_SIGNAL, xStart, xEnd, zStart, zEnd, packedLight, normal, 0.0625f);
        } else if (!be.hasClientInteracted()) {
            this.renderNoise(pose, buffer, xStart, xEnd, zStart, zEnd, packedLight, normal, 0.0625f);
            this.renderCutoutTexture(pose, buffer, INACTIVE, xStart, xEnd, zStart, zEnd, packedLight, normal, 0.0625f);
        } else {
            BlockEntity blockEntity;
            CameraFeed feed = FrameFeedHandler.getFeed(cameraPos);
            if (!(feed != null && feed.isFrameLinked(be) && level.isLoaded(cameraPos.pos()) && (blockEntity = level.getBlockEntity(cameraPos.pos())) instanceof SecurityCameraBlockEntity)) {
                this.renderSolidTexture(pose, buffer, CAMERA_NOT_FOUND, xStart, xEnd, zStart, zEnd, packedLight, normal, 0.0625f);
            } else {
                SecurityCameraBlockEntity cameraBlockEntity = (SecurityCameraBlockEntity)blockEntity;
                if (!FrameFeedHandler.isCapturingCamera()) {
                    ItemStack lens;
                    RenderTarget target = feed.renderTarget();
                    ShaderInstance shader = ClientHandler.getFrameFeedShader();
                    shader.setSampler("DiffuseSampler", (Object)target.getColorTextureId());
                    if (shader.MODEL_VIEW_MATRIX != null) {
                        shader.MODEL_VIEW_MATRIX.set(pose.last().pose());
                    }
                    if (shader.PROJECTION_MATRIX != null) {
                        shader.PROJECTION_MATRIX.set(RenderSystem.getProjectionMatrix());
                    }
                    shader.apply();
                    Matrix4f lastPose = pose.last().pose();
                    VertexConsumer bufferBuilder = buffer.getBuffer(CAMERA_IN_FRAME_RENDER_TYPE);
                    bufferBuilder.addVertex(lastPose, xStart, 0.0625f, zStart).setUv(1.0f, 0.0f).setColor(0xFFFFFF);
                    bufferBuilder.addVertex(lastPose, xStart, 0.9375f, zStart).setUv(1.0f, 1.0f).setColor(0xFFFFFF);
                    bufferBuilder.addVertex(lastPose, xEnd, 0.9375f, zEnd).setUv(0.0f, 1.0f).setColor(0xFFFFFF);
                    bufferBuilder.addVertex(lastPose, xEnd, 0.0625f, zEnd).setUv(0.0f, 0.0f).setColor(0xFFFFFF);
                    shader.clear();
                    if (buffer instanceof MultiBufferSource.BufferSource) {
                        MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)buffer;
                        bufferSource.endBatch();
                    }
                    if ((lens = cameraBlockEntity.getLensContainer().getItem(0)).has(DataComponents.DYED_COLOR)) {
                        this.renderOverlay(pose, buffer, ((DyedItemColor)lens.get(DataComponents.DYED_COLOR)).rgb() + (cameraBlockEntity.getOpacity() << 24), xStart, xEnd, zStart, zEnd, 0.0625f);
                    }
                }
            }
        }
    }

    private void renderNoise(PoseStack pose, MultiBufferSource buffer, float xStart, float xEnd, float zStart, float zEnd, int packedLight, Vec3i normal, float margin) {
        this.renderTexture(pose, buffer, NOISE_BACKGROUND.buffer(buffer, RenderType::entitySolid), xStart, xEnd, zStart, zEnd, packedLight, normal, margin);
    }

    private void renderSolidTexture(PoseStack pose, MultiBufferSource buffer, ResourceLocation texture, float xStart, float xEnd, float zStart, float zEnd, int packedLight, Vec3i normal, float margin) {
        this.renderTexture(pose, buffer, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)texture)), xStart, xEnd, zStart, zEnd, packedLight, normal, margin);
    }

    private void renderCutoutTexture(PoseStack pose, MultiBufferSource buffer, ResourceLocation texture, float xStart, float xEnd, float zStart, float zEnd, int packedLight, Vec3i normal, float margin) {
        this.renderTexture(pose, buffer, buffer.getBuffer(RenderType.entityCutout((ResourceLocation)texture)), xStart, xEnd, zStart, zEnd, packedLight, normal, margin);
    }

    private void renderTexture(PoseStack pose, MultiBufferSource buffer, VertexConsumer bufferBuilder, float xStart, float xEnd, float zStart, float zEnd, int packedLight, Vec3i normal, float margin) {
        PoseStack.Pose last = pose.last();
        Matrix4f lastPose = last.pose();
        int nx = normal.getX();
        int ny = normal.getY();
        int nz = normal.getZ();
        bufferBuilder.addVertex(lastPose, xStart, margin, zStart).setUv(1.0f, 1.0f).setColor(0xFFFFFF).setLight(packedLight).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(last, (float)nx, (float)ny, (float)nz);
        bufferBuilder.addVertex(lastPose, xStart, 1.0f - margin, zStart).setUv(1.0f, 0.0f).setColor(0xFFFFFF).setLight(packedLight).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(last, (float)nx, (float)ny, (float)nz);
        bufferBuilder.addVertex(lastPose, xEnd, 1.0f - margin, zEnd).setUv(0.0f, 0.0f).setColor(0xFFFFFF).setLight(packedLight).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(last, (float)nx, (float)ny, (float)nz);
        bufferBuilder.addVertex(lastPose, xEnd, margin, zEnd).setUv(0.0f, 1.0f).setColor(0xFFFFFF).setLight(packedLight).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(last, (float)nx, (float)ny, (float)nz);
        if (buffer instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)buffer;
            bufferSource.endBatch();
        }
    }

    private void renderOverlay(PoseStack pose, MultiBufferSource buffer, int color, float xStart, float xEnd, float zStart, float zEnd, float margin) {
        VertexConsumer bufferBuilder = buffer.getBuffer(RenderType.gui());
        Matrix4f lastPose = pose.last().pose();
        bufferBuilder.addVertex(lastPose, xStart, margin, zStart).setColor(color);
        bufferBuilder.addVertex(lastPose, xStart, 1.0f - margin, zStart).setColor(color);
        bufferBuilder.addVertex(lastPose, xEnd, 1.0f - margin, zEnd).setColor(color);
        bufferBuilder.addVertex(lastPose, xEnd, margin, zEnd).setColor(color);
        if (buffer instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)buffer;
            bufferSource.endBatch();
        }
    }
}

